import distribs
import makeclusters
import dill
#todo: persistence
import os

class ObjectContainer:
    _instance=None
    _cache = {}

    @classmethod
    def getInstance(cls):
        if cls._instance is None:
            cls._instance = ObjectContainer()
        return cls._instance

    @classmethod
    def get_cache(cls,what):
        if what in cls._cache.keys():
            return cls._cache[what]
        return None

    @classmethod
    def set_cache(cls,what,v):
        cls._cache[what]=v
        
   

    
    def __init__(self):
        self._container={}
        self._depend = {}
        self.load()
        
        
    def get(self,name):
        return self._container[name]
    def __contains__(self,name):
        return name in self._container.keys()
   
    def set(self,name,value):
        self._container[name]=value
    
    def save(self):
        with open ('objcont.plk','wb') as f:
            dill.dump(self._container,f)
    def load(self):
        if os.path.isfile('objcont.plk'):
            with open('objcont.plk','rb') as f:
                self._container = dill.load(f)
            
if __name__ == "__main__":
    ob = ObjectContainer.getInstance()
    print (ob._container)