import configparser
import numpy as np

class ConfigReader:
    def __init__(self,path):
        self._path = path
        self._config = configparser.ConfigParser()
        self._config.read(path)
        
    def server(self):
        return self._config['tcpip']['server']
    def port(self):
        return int(self._config['tcpip']['port'])
    
    def scavroot(self):
        return self._config['scav']['root']
    
    def dates(self):
        x = np.datetime64(self._config['scav']['datefrom']).astype(object)
        y = np.datetime64(self._config['scav']['dateto']).astype(object)
        return x,y
    
    def scavsuffix(self):
        return self._config['scav']['filetype']
    
    def scavformat(self):
        return self._config['scav']['fileformat']
    
    def scavout(self):
        return self._config['scav']['fileout']
    
    def scavlistfield(self):
        return self._config['scav']['listfields']
    
    def distrmastersource(self) :
        return self._config['distributions']['mastersource']
    
    def distrfields(self):
        return self._config['distributions']['fields'].split(',')
    
    def distrws(self):
        return int(self._config['distributions']['windowsize'])
    
    def distroverlap(self):
        return int(self._config['distributions']['overlap'])
    
    def mastercovlist(self):
        return self._config['distributions']['mastercovlist']
    
    def clusterN(self):
        return int(self._config['clusters']['N'])
   
    def claffinity(self):
        return self._config['clusters']['affinity']
   
    def cleigen_solver(self):
        return self._config['clusters']['eigen_solver']
    
    def clspectral_neighbors(self):
        return int(self._config['clusters']['spectraln_neighbors'])
    
    def cln_neighbors(self):
        return int(self._config['clusters']['n_neighbors'])  
    
    def clrandom_states(self):
        return int(self._config['clusters']['random_states'])  
    
    def smooth_hellinger(self):
        return bool(self._config['clusters']['smooth hellinger'])
    
    def reg_threshold(self):
        return int(self._config['regimes']['threshold'])
    def outcl(self):
        return self._config['clusters']['output']      
    def outreg(self):
        return self._config['regimes']['output']
    def incl(self):
        return self._config['regimes']['input']
    def clmap(self):
        return self._config['graphs']['cmap']
    def dataref(self):
        return self._config['graphs']['dataref']
        
if __name__ == "__main__":
    c = ConfigReader('regimes.ini')
    print (c.scavlistfield())