from time import sleep


class ProgressBar:
    def __init__(self, total, prefix='',suffix='',decimals=1,length=100, fill = '█'):
        self._total = total
        self._iteration=0
        self._prefix = prefix
        self._prefix = prefix
        self._suffix = suffix
        self._decimals = decimals
        self._length = length
        self._fill = fill
        self._percent=0
    
    def _display(self):
        self._percent = ("{0:." + str(self._decimals) + "f}").format(100 * (self._iteration / float(self._total)))
        filledLength = int(self._length * self._iteration // self._total)
        bar = self._fill * filledLength + '-' * (self._length - filledLength)
        print('\r%s |%s| %s%% %s' % (self._prefix, bar, self._percent, self._suffix), end = '\r')
        # Print New Line on Complete
        if self._iteration == self._total: 
            print() 
            
    def iterate(self, inc=1):
        sleep(0)
        self._iteration += inc
        self._display()
        
    
if __name__ == "__main__":
    pr=ProgressBar(50,prefix='Progress',suffix='Complete',length=50)
    for i in range(0,50):
        pr.iterate()
        
       
